;;; Sierra Script 1.0 - (do not remove this comment)
;
; SCI Template Game
; By Brian Provinciano
; ******************************************************************************
; titlescreen.sc
; Contains the title screen room.
(script# TITLESCREEN_SCRIPT)
(include sci.sh)
(include game.sh)
(use main)
(use game)
(use menubar)
(use obj)
(use cycle)
(use user)
(use controls)
(use feature)
(use FileIO)

(public
	TitleScreen 0
)




(instance TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	
	(method (init &tmp [tempStr 200] scoreFile num)
		; Set up the title screen
		(ProgramControl)
		(= gProgramControl FALSE)
		(gGame setSpeed: 1)
		(SL disable:)
		(TheMenuBar hide:)
		(super init:)
		(self setScript: RoomScript)
		(gEgo init: hide:)
;
;         * Set up the room's music to play here *
		;
		; (send gTheMusic:
		; 	prevSignal(0)
		; 	stop()
		; 	number(scriptNumber)
		; 	loop(-1)
		; 	play()
		; )
;
;         * Add the rest of your initialization stuff here *
		(Display {SCI Tetris} dsCOORD 2 42 dsALIGN alCENTER dsCOLOUR clWHITE dsFONT 100 dsWIDTH 320)
		(Display {SCI Tetris} dsCOORD 1 41 dsALIGN alCENTER dsCOLOUR clBLACK dsFONT 100 dsWIDTH 320)
		(Display {SCI Tetris} dsCOORD 0 40 dsALIGN alCENTER dsCOLOUR clMAROON dsFONT 100 dsWIDTH 320)
		
		(Display {by Rainer De Temple} dsCOORD 0 150 dsALIGN alCENTER dsCOLOR clGREY dsFONT 1 dsWIDTH 320)
		(Display {by Rainer De Temple} dsCOORD 1 150 dsALIGN alCENTER dsCOLOR clMAROON dsFONT 1 dsWIDTH 320)
		(Format @tempStr {Version %s} gVersion)
		(Display @tempStr dsCOORD 0 162 dsALIGN alCENTER dsCOLOR clGREY dsFONT 4 dsWIDTH 320)
		(Display @tempStr dsCOORD 1 162 dsALIGN alCENTER dsCOLOR clSILVER dsFONT 4 dsWIDTH 320)
		
		(Display {Press any key to play} dsCOORD 1 99 dsALIGN alCENTER dsCOLOR clGREY  dsWIDTH 320) ; above
		(Display {Press any key to play} dsCOORD 1 101 dsALIGN alCENTER dsCOLOR clGREY  dsWIDTH 320) ; below
		(Display {Press any key to play} dsCOORD 0 100 dsALIGN alCENTER dsCOLOR clGREY  dsWIDTH 320) ; left
		(Display {Press any key to play} dsCOORD 2 100 dsALIGN alCENTER dsCOLOR clGREY  dsWIDTH 320) ; right
		(Display {Press any key to play} dsCOORD 1 100 dsALIGN alCENTER dsCOLOR clWHITE  dsWIDTH 320)
		
		(= scoreFile (File new:))
		(if (!= NULL (= scoreFile (FOpen "hiscore.txt" fOPENCREATE)))
			(if (FGets tempStr 40 scoreFile) 
				(= gMaxScore (ReadNumber tempStr))
			)
		) 
		(FClose scoreFile)
	)
)


(instance RoomScript of Script
	(properties)
	
;
;    (method (changeState newState)
;        = state newState
;        /************************************
;         * Add the state related stuff here *
	; )
	(method (handleEvent pEvent)
		(super handleEvent: pEvent)
		(if (not (pEvent claimed?))
			(if
				(and
					(== (pEvent type?) evKEYBOARD)
					(== (pEvent message?) $3c00)
				)
				(ToggleSound)
			else
;
;                 * If the title screen has music, fade it *
				; (send gTheMusic:fade())
				; End the title screen, start the game
				(gRoom newRoom: INITROOMS_SCRIPT)
			)
		)
	)
)
